dnl Copyright (C) 2001 Daniel Caujolle-Bert <segfault@club-internet.fr>
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl  
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl  
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl  
dnl  
dnl As a special exception to the GNU General Public License, if you
dnl distribute this file as part of a program that contains a configuration
dnl script generated by Autoconf, you may include it under the same
dnl distribution terms that you use for the rest of that program.
dnl  

dnl
dnl get location of kernel headers
dnl
AC_DEFUN(AC_KERNEL_INCLUDES,
[
  AC_ARG_WITH(kernel-includes,
     [  --with-kernel-includes=DIR ]
     [                     Kernel include files are in DIR]
     [                       default = /usr/src/linux/include ],
     [KERNEL_INCLUDES="$withval"],                             
     [KERNEL_INCLUDES=/usr/src/linux/include])

  ac_save_CPPFLAGS="$CPPFLAGS"
  CPPFLAGS="$CFLAGS -I$KERNEL_INCLUDES"
  AC_CHECK_HEADER($KERNEL_INCLUDES/linux/modversions.h,, 
     AC_MSG_ERROR(modversions.h is missing - you should configure your kernel first!))
  CPPFLAGS="$ac_save_CPPFLAGS"

dnl some real checks.
  KERNEL_VERSION="0.0.0"
  rm -f uts_release.c uts_release

cat > uts_release.c <<EOF
#include <linux/version.h>
int main() {
  printf("%s\n", UTS_RELEASE);
  return 0;
}
EOF

  if test -f ./uts_release.c; then
    $CC -I$KERNEL_INCLUDES -o uts_release uts_release.c
    if test -x ./uts_release; then
      KERNEL_VERSION="`./uts_release`"
    fi
  fi

  rm -f uts_release.c uts_release
	
  AC_SUBST(KERNEL_INCLUDES)
  AC_SUBST(KERNEL_VERSION)
])



dnl AC_CHECK_KERNEL([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
AC_DEFUN(AC_CHECK_KERNEL,
[
  AC_REQUIRE([AC_KERNEL_INCLUDES])

  min_kernel_version=ifelse([$1], ,2.4.7,$1)

  AC_MSG_CHECKING(for Linux kernel version >= $min_kernel_version)

  real_kernel_version="`eval echo $KERNEL_VERSION | sed -e 's/-[[a-zA-Z0-9]][[^-]]*$//g' | awk -F'.' '{ print $[]1"."$[]2"."$[]3 }'`"

  k_version="`echo $real_kernel_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`"
  k_patch="`echo $real_kernel_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`"
  k_sub="`echo $real_kernel_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`"

  v_min="`echo $min_kernel_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`"
  p_min="`echo $min_kernel_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`"
  s_min="`echo $min_kernel_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`"

  if test [ $k_version -gt $v_min ] \
	-o [ $k_version -eq $v_min -a $k_patch -gt $p_min ] \
	-o [ $k_version -eq $v_min -a $k_patch -eq $p_min -a $k_sub -ge $s_min ]; then

    ac_save_CFLAGS="$CFLAGS"
    CFLAGS="$CFLAGS -I$KERNEL_INCLUDES"
    AC_LANG_SAVE()
    AC_LANG_C()
    rm -f conf.kerneltest
    AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <linux/version.h>

int 
main () {
  int major, minor, sub;
  char *tmp_version;
  int version;

  system ("touch conf.kerneltest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = (char *) strdup("$min_kernel_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &sub) != 3) {
     printf("%s, bad version string\n", "$min_kernel_version");
     exit(1);
  }

  version = ((major << 16) + (minor << 8) + sub);

  if (LINUX_VERSION_CODE >= version) {
     return 0;
  }
  else {
     printf("*** An old linux version(%s) sources was found.\n", UTS_RELEASE);
     printf("*** You need a version of linux kernel newer or equal to %d.%d.%d.\n",
	    major, minor, sub);
     printf("The latest version of linux kernel is available from:\n");
     printf("***        ftp://ftp.kernel.org\n");
     printf("***\n");
  }
  return 1;
}
],, wrong_kernel_version=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])

     if test "x$wrong_kernel_version" = "x" ; then
       AC_MSG_RESULT(yes)
       ifelse([$2], , :, [$2])     
     else
       AC_MSG_RESULT(no)
       ifelse([$3], , :, [$3])
     fi

     AC_LANG_RESTORE()
     CFLAGS="$ac_save_CFLAGS"
     rm -f conf.kerneltest

  else
    AC_MSG_RESULT(no)
    ifelse([$3], , :, [$3])
  fi
])
