/*
 *	This file is to be linked with the rest of the libraries in
 *	the distribution package.
 */

#include <linux/config.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/slab.h>
#include <linux/delay.h>
#if (LINUX_VERSION_CODE >= 131343)
#include <linux/init.h>
#endif

void Pctel_module_init(void)
{
	MOD_INC_USE_COUNT;
}

void Pctel_module_free(void)
{
	MOD_DEC_USE_COUNT;
}

int Pctel_module_is_free(void)
{
	return (MOD_IN_USE == 0);
}

void *pctel_kmalloc(size_t size, int flags)
{
	
	return kmalloc(size, GFP_KERNEL|GFP_ATOMIC);
}

void pctel_kfree(const void *objp)
{
	kfree(objp);
}

void pctel___udelay(unsigned long usecs)
{
	__udelay(usecs);
}

static int __init pctel_init(void)
{
	return 0;
}

static void __exit pctel_cleanup(void) 
{
}

module_init(pctel_init);
module_exit(pctel_cleanup);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 10)
MODULE_LICENSE("GPL linked with proprietary libraries");
#endif
